Rem AdjustPageItems.vbs
Rem An InDesign VBScript
Rem
Rem Moves the content of even/odd pages by specified amounts; attempts to get
Rem objects back into the correct position after a master page margin change
Rem and/or page insertion.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem Or visit the InDesign Scripting User to User forum at http://www.adobeforums.com.
Rem
main
Function main()
	Set myInDesign = CreateObject("InDesign.Application.2024")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll	
	If myInDesign.Documents.Count <> 0 Then
	    If myInDesign.ActiveDocument.PageItems.Count <> 0 Then
	        myDisplayDialog myInDesign
	    End If
	End If
End Function
Function myDisplayDialog(myInDesign)
    myLabelWidth = 70
    Set myDialog = myInDesign.Dialogs.Add
    myDialog.name = "Adjust Page Items"
    myPageNames = myGetPageNames(myInDesign.ActiveDocument)
    With myDialog.DialogColumns.Add
        With .BorderPanels.Add
            With .DialogColumns.Add
                With .DialogRows.Add
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = "Start Page:"
                            .MinWidth = myLabelWidth
                        End With
                    End With
                    With .DialogColumns.Add
                        Set myStartPageDropdown = .Dropdowns.Add
                        With myStartPageDropdown
                            .StringList = myPageNames
                            .selectedIndex = 0
                        End With
                    End With
                End With
                With .DialogRows.Add
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = "End Page:"
                            .MinWidth = myLabelWidth
                        End With
                    End With
                    With .DialogColumns.Add
                        Set myEndPageDropdown = .Dropdowns.Add
                        With myEndPageDropdown
                            .StringList = myPageNames
                            .selectedIndex = UBound(myPageNames)
                        End With
                    End With
                End With
            End With
        End With
        With .BorderPanels.Add
            With .DialogColumns.Add
                With .DialogRows.Add
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = "Even Pages"
                            .MinWidth = myLabelWidth
                        End With
                        With .StaticTexts.Add
                            .staticLabel = "Horizontal"
                            .MinWidth = myLabelWidth
                        End With
                        With .StaticTexts.Add
                            .staticLabel = "Vertical"
                            .MinWidth = myLabelWidth
                        End With
                    End With
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = ""
                        End With
                        Set myEvenXField = .MeasurementEditboxes.Add
                        With myEvenXField
                            .editValue = -12
                            .EditUnits = idMeasurementUnits.idPoints
                        End With
                        Set myEvenYField = .MeasurementEditboxes.Add
                        With myEvenYField
                            .editValue = 12
                            .EditUnits = idMeasurementUnits.idPoints
                        End With
                    End With
                End With
            End With
        End With
        With .BorderPanels.Add
            With .DialogColumns.Add
                With .DialogRows.Add
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = "Odd Pages"
                            .MinWidth = myLabelWidth
                        End With
                        With .StaticTexts.Add
                            .staticLabel = "Horizontal:"
                            .MinWidth = myLabelWidth
                        End With
                        With .StaticTexts.Add
                            .staticLabel = "Vertical:"
                            .MinWidth = myLabelWidth
                        End With
                    End With
                    With .DialogColumns.Add
                        With .StaticTexts.Add
                            .staticLabel = ""
                        End With
                        Set myOddXField = .MeasurementEditboxes.Add
                        With myOddXField
                            .editValue = 12
                            .EditUnits = idMeasurementUnits.idPoints
                        End With
                        Set myOddYField = .MeasurementEditboxes.Add
                        With myOddYField
                            .editValue = 12
                            .EditUnits = idMeasurementUnits.idPoints
                        End With
                    End With
                End With
            End With
        End With
    End With
    myResult = myDialog.Show
    If myResult = True Then
        myStartPageName = myPageNames(myStartPageDropdown.selectedIndex)
        myEndPageName = myPageNames(myEndPageDropdown.selectedIndex)
        If myCheckPageRange(myInDesign, myStartPageName, myEndPageName) = True Then
            myEvenX = myEvenXField.editValue
            myEvenY = myEvenYField.editValue
            myOddX = myOddXField.editValue
            myOddY = myOddYField.editValue
            myDialog.Destroy
            myAdjustPages myInDesign, myEvenX, myEvenY, myOddX, myOddY, myStartPageName, myEndPageName
        Else
            myDialog.Destroy
            MsgBox "Invalid page range."
        End If
    Else
        myDialog.Destroy
    End If
End Function
Function myCheckPageStart(myDocument)
    Set mySection = myDocument.Sections.Item(1)
    If mySection.ContinueNumbering = True Then
        Rem Starting page number is defined by other documents in the book
        myCheckPageStart = True
    End If
    If mySection.PageNumberStart Mod 2 = 0 Then
        Rem Starting page number is an even page.
        myCheckPageStart = False
    Else
        Rem Starting page number is an odd page.
        myCheckPageStart = True
    End If
End Function
Function myAdjustPages(myInDesign, myEvenX, myEvenY, myOddX, myOddY, myStartPageName, myEndPageName)
    myOldXUnits = myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits
    myOldYUnits = myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits
    Rem Set the measurement units to points.
    myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = idMeasurementUnits.idPoints
    myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = idMeasurementUnits.idPoints
    Rem Save the old page numbering
    myOldPageNumbering = myInDesign.GeneralPreferences.PageNumbering
    myInDesign.GeneralPreferences.PageNumbering = idPageNumberingOptions.idSection
    Set myStartPage = myInDesign.ActiveDocument.Pages.Item(myStartPageName)
    Set myEndPage = myInDesign.ActiveDocument.Pages.Item(myEndPageName)
    Rem Set page numbering to absolute
    myInDesign.GeneralPreferences.PageNumbering = idPageNumberingOptions.idAbsolute
    Rem Does the page start with an even page?
    If myCheckPageStart(myInDesign.ActiveDocument) = False Then
        myPageAdjust = 1
    Else
        myPageAdjust = 0
    End If
    For myCounter = myStartPage.DocumentOffset To myEndPage.DocumentOffset
        Set myPage = myInDesign.ActiveDocument.Pages.Item(myCounter)
        If CInt(myPage.DocumentOffset + myPageAdjust) Mod 2 = 0 Then
            Rem Page is an even page.
            myAdjustPage myInDesign, myPage, myEvenX, myEvenY
        Else
            Rem Page is an odd page.
            myAdjustPage myInDesign, myPage, myOddX, myOddY
        End If
    Next
    Rem Reset the transform content and measurement units to their original values.
    myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = myOldXUnits
    myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = myOldYUnits
    myInDesign.GeneralPreferences.PageNumbering = myOldPageNumbering
End Function

Function myAdjustPage(myInDesign, myPage, myX, myY)
    For myCounter = 1 To myPage.PageItems.Count
        myResetItemLock = False
        myResetLayerLock = False
        Set myPageItem = myPage.PageItems.Item(myCounter)
        If myPageItem.Locked = True Then
            myPageItem.Locked = False
            myResetItemLock = True
        End If
        If myPageItem.ItemLayer.Locked = True Then
            myPageItem.ItemLayer.Locked = False
            myResetLayerLock = True
        End If
        myPageItem.Move , Array(myX, myY)
        If myResetItemLock = True Then
            myPageItem.Locked = True
        End If
        If myResetLayerLock = True Then
            myPageItem.ItemLayer.Locked = True
        End If
    Next
End Function
Function myGetPageNames(myDocument)
    ReDim myPageNames(0)
    For myCounter = 1 To myDocument.Pages.Count
        If myCounter > 1 Then
            ReDim Preserve myPageNames(UBound(myPageNames) + 1)
        End If
        myPageNames(UBound(myPageNames)) = myDocument.Pages.Item(myCounter).name
    Next
    myGetPageNames = myPageNames
End Function
Function myCheckPageRange(myInDesign, myStartPageName, myEndPageName)
    myStartIndex = myInDesign.ActiveDocument.Pages.Item(myStartPageName).DocumentOffset
    myEndIndex = myInDesign.ActiveDocument.Pages.Item(myEndPageName).DocumentOffset
    If myStartIndex <= myEndIndex Then
        myCheckPageRange = True
    Else
        myCheckPageRange = False
    End If
End Function

'' SIG '' Begin signature block
'' SIG '' MIIpyQYJKoZIhvcNAQcCoIIpujCCKbYCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' LLRWAA8O+X6vP/uQubeAKmUb+n4R8BgrM8ZRQ8Cfdnug
'' SIG '' gg6WMIIGsDCCBJigAwIBAgIQCK1AsmDSnEyfXs2pvZOu
'' SIG '' 2TANBgkqhkiG9w0BAQwFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjEwNDI5MDAwMDAw
'' SIG '' WhcNMzYwNDI4MjM1OTU5WjBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMIICIjANBgkq
'' SIG '' hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1bQvQtAorXi3
'' SIG '' XdU5WRuxiEL1M4zrPYGXcMW7xIUmMJ+kjmjYXPXrNCQH
'' SIG '' 4UtP03hD9BfXHtr50tVnGlJPDqFX/IiZwZHMgQM+TXAk
'' SIG '' ZLON4gh9NH1MgFcSa0OamfLFOx/y78tHWhOmTLMBICXz
'' SIG '' ENOLsvsI8IrgnQnAZaf6mIBJNYc9URnokCF4RS6hnyzh
'' SIG '' GMIazMXuk0lwQjKP+8bqHPNlaJGiTUyCEUhSaN4QvRRX
'' SIG '' XegYE2XFf7JPhSxIpFaENdb5LpyqABXRN/4aBpTCfMjq
'' SIG '' GzLmysL0p6MDDnSlrzm2q2AS4+jWufcx4dyt5Big2MEj
'' SIG '' R0ezoQ9uo6ttmAaDG7dqZy3SvUQakhCBj7A7CdfHmzJa
'' SIG '' wv9qYFSLScGT7eG0XOBv6yb5jNWy+TgQ5urOkfW+0/tv
'' SIG '' k2E0XLyTRSiDNipmKF+wc86LJiUGsoPUXPYVGUztYuBe
'' SIG '' M/Lo6OwKp7ADK5GyNnm+960IHnWmZcy740hQ83eRGv7b
'' SIG '' UKJGyGFYmPV8AhY8gyitOYbs1LcNU9D4R+Z1MI3sMJN2
'' SIG '' FKZbS110YU0/EpF23r9Yy3IQKUHw1cVtJnZoEUETWJrc
'' SIG '' JisB9IlNWdt4z4FKPkBHX8mBUHOFECMhWWCKZFTBzCEa
'' SIG '' 6DgZfGYczXg4RTCZT/9jT0y7qg0IU0F8WD1Hs/q27Iwy
'' SIG '' CQLMbDwMVhECAwEAAaOCAVkwggFVMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwHQYDVR0OBBYEFGg34Ou2O/hfEYb7/mF7
'' SIG '' CIhl9E5CMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/n
'' SIG '' upiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
'' SIG '' BggrBgEFBQcDAzB3BggrBgEFBQcBAQRrMGkwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBB
'' SIG '' BggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQw
'' SIG '' QwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
'' SIG '' cmwwHAYDVR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEw
'' SIG '' DQYJKoZIhvcNAQEMBQADggIBADojRD2NCHbuj7w6mdNW
'' SIG '' 4AIapfhINPMstuZ0ZveUcrEAyq9sMCcTEp6QRJ9L/Z6j
'' SIG '' fCbVN7w6XUhtldU/SfQnuxaBRVD9nL22heB2fjdxyyL3
'' SIG '' WqqQz/WTauPrINHVUHmImoqKwba9oUgYftzYgBoRGRjN
'' SIG '' YZmBVvbJ43bnxOQbX0P4PpT/djk9ntSZz0rdKOtfJqGV
'' SIG '' WEjVGv7XJz/9kNF2ht0csGBc8w2o7uCJob054ThO2m67
'' SIG '' Np375SFTWsPK6Wrxoj7bQ7gzyE84FJKZ9d3OVG3ZXQIU
'' SIG '' H0AzfAPilbLCIXVzUstG2MQ0HKKlS43Nb3Y3LIU/Gs4m
'' SIG '' 6Ri+kAewQ3+ViCCCcPDMyu/9KTVcH4k4Vfc3iosJocsL
'' SIG '' 6TEa/y4ZXDlx4b6cpwoG1iZnt5LmTl/eeqxJzy6kdJKt
'' SIG '' 2zyknIYf48FWGysj/4+16oh7cGvmoLr9Oj9FpsToFpFS
'' SIG '' i0HASIRLlk2rREDjjfAVKM7t8RhWByovEMQMCGQ8M4+u
'' SIG '' KIw8y4+ICw2/O/TOHnuO77Xry7fwdxPm5yg/rBKupS8i
'' SIG '' bEH5glwVZsxsDsrFhsP2JjMMB0ug0wcCampAMEhLNKhR
'' SIG '' ILutG4UI4lkNbcoFUCvqShyepf2gpx8GdOfy1lKQ/a+F
'' SIG '' SCH5Vzu0nAPthkX0tGFuv2jiJmCG6sivqf6UHedjGzqG
'' SIG '' VnhOMIIH3jCCBcagAwIBAgIQD99ExMbwCe2qSx8hp1o/
'' SIG '' EDANBgkqhkiG9w0BAQsFADBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMB4XDTIzMTEw
'' SIG '' MzAwMDAwMFoXDTI1MTEwNDIzNTk1OVowgeYxEzARBgsr
'' SIG '' BgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIBAhMI
'' SIG '' RGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3JnYW5p
'' SIG '' emF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYDVQQG
'' SIG '' EwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNhbiBK
'' SIG '' b3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYDVQQL
'' SIG '' EyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29weSwg
'' SIG '' TXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCAiIwDQYJ
'' SIG '' KoZIhvcNAQEBBQADggIPADCCAgoCggIBAPCR5c/cgyg4
'' SIG '' MpJD46/+BWENPhE1RjN77VE2BWlIUdiO2nlWelKthEq9
'' SIG '' aK+1ofKIlDVc9mvxksuXBLESi7HBt3PCVBntNJkjBJd0
'' SIG '' EXeprmDK8HZrz8y/KSwEewbTMjneMRIRcJV2GMoAyUzK
'' SIG '' EyFJF7m6ByeoNBDDXMD4AQF5C2l3wfvRbREw+G+cyeya
'' SIG '' 564AHpFJ9sfqi9jAycnEZISxEf6N72GgGQr04cZt3JTb
'' SIG '' TktZGt6uWdZnseXDLGRHzFu4P4EqmVKvfMDliaKyWBzV
'' SIG '' lY+gmtE1vSxIK79WTySFrFY5j1vtbKyHybk6tv4TOmLt
'' SIG '' Lw4OP/ngVDiw/ZP+b7saGxPOEfuh5LOAr+llt+6V5NhT
'' SIG '' dkYPR6cbokawwX2DbGg7IeVuUPdf9bx/LznFV/8kPxCB
'' SIG '' J6qg0dqvCmQt/XbBXPJUvDoVJ9z+9hDlrAoLESqpHK8U
'' SIG '' 73UFGohBMJ/7itIyKngem7Ms98z6x0i63FJA8C06g+XE
'' SIG '' GJUmR28+c6ba+m/sc6xHI4zdL5a84UeRS9+u8UL8N4av
'' SIG '' fpSxHYTTxVjk1ZlwQ8dLARwEVWvTu4lRcEck3RPogx7o
'' SIG '' o8wUpSw9++m+Oi+K/z7RP/R67uCEtrkdM5N/xUoQR/t6
'' SIG '' 3P2ia9g8+LuYJ2BNBd1+qMcSoSlDfIFLFMeeqESbMv+j
'' SIG '' UsRQJn2lZvufAgMBAAGjggICMIIB/jAfBgNVHSMEGDAW
'' SIG '' gBRoN+Drtjv4XxGG+/5hewiIZfROQjAdBgNVHQ4EFgQU
'' SIG '' RPnrJ9yT26rMrd/Q4PfQSlgeaRcwPQYDVR0gBDYwNDAy
'' SIG '' BgVngQwBAzApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbS9DUFMwDgYDVR0PAQH/BAQDAgeA
'' SIG '' MBMGA1UdJQQMMAoGCCsGAQUFBwMDMIG1BgNVHR8Ega0w
'' SIG '' gaowU6BRoE+GTWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNB
'' SIG '' NDA5NlNIQTM4NDIwMjFDQTEuY3JsMFOgUaBPhk1odHRw
'' SIG '' Oi8vY3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIx
'' SIG '' Q0ExLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBc
'' SIG '' BggrBgEFBQcwAoZQaHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25p
'' SIG '' bmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcnQwCQYDVR0T
'' SIG '' BAIwADANBgkqhkiG9w0BAQsFAAOCAgEAPIZ9C4IuKg85
'' SIG '' 0H8M66OLMVllIpANmEjijIG/D65qP6jfma+2WFps2bb+
'' SIG '' vKKIEtG9TFtCAlSrA1OV6Ru78paq0gqw/q3QAN0OleFR
'' SIG '' F1NvT/TLO0ulhjXTETB1BwSKZaJH001DH0+60TmbGfVh
'' SIG '' mwLrEj2Zfl4COFwivZ/2tRoknZl5tmiu4hpjDbOapWd9
'' SIG '' 5cqliSoMeu2i588557eikdiDk6bXBa5MxHjyXvbvaIWN
'' SIG '' Zjsymn0L0sYkF3BToDN0h0XiTTZjZPHdSV2GjX6C/+Nj
'' SIG '' HSZGRtBaIxdAL1mKEWJV9qkEKELPb098rO+zGdn1E5IH
'' SIG '' pS1zSRIYngwZEjZfyoCkg1F+EW4QPs2+ff2CsW5i3IEd
'' SIG '' 7vL19w9oyce3S4wejvnlTKt+EQWn3gSPxrbkp3BxdWRN
'' SIG '' 25MKo5bS5bJ21BiwqcIJHcTxWNgaQPh4sZboi9IimCSn
'' SIG '' UenPQhqdeOuz0NnmepMEYd7L/kqnAeUZ8bW1UbITAWQ/
'' SIG '' UT3phjCfRQNpEh4OBoUcH8hOOHZ0Lh86mxv9lDP3i7c/
'' SIG '' bQzZnrJr2dS34JXolwREbTX9Yu5JB5X3YP539/M1Ms5O
'' SIG '' FZou/MHQBrWMsVBsEXDTWqwbMTYw/zvIiHXcGUnpzInw
'' SIG '' 1jQXlLrmwVHW4ug+A4LFO7bWC4mnZoDNWp0xnlGmbP6I
'' SIG '' ccJmW5C7RJMxghqLMIIahwIBATB9MGkxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8G
'' SIG '' A1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNp
'' SIG '' Z25pbmcgUlNBNDA5NiBTSEEzODQgMjAyMSBDQTECEA/f
'' SIG '' RMTG8AntqksfIadaPxAwDQYJYIZIAWUDBAIBBQCggZww
'' SIG '' GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
'' SIG '' BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcN
'' SIG '' AQkEMSIEIIR/MF0sLkH4xMkpujRonbfy5a1PKtE+xuhN
'' SIG '' iInDdrExMDAGCisGAQQBgjcCAQwxIjAgoB6AHABBAGQA
'' SIG '' bwBiAGUAIABJAG4ARABlAHMAaQBnAG4wDQYJKoZIhvcN
'' SIG '' AQEBBQAEggIAqbICJUA1NfcGw1rrvgEfvA3BhEq/CiKh
'' SIG '' 31IOX8fjbZ76cFA3C9KMxUAdp7IPwtU4YRzhdKHdoE3K
'' SIG '' CS4AOQHNyh063C7H9HLXG0ewzCGCde4ET6DhaBF1N5oO
'' SIG '' oocdiqTc2sLgORa6DXFd7oqpxiPSbgANvM9sZADGfGRi
'' SIG '' IlCK0p9y0WLznR8voYCVdawHS6b3tH2vaxv8D6p4cAtb
'' SIG '' Qub2/rzgTL1Lo8ITQ1wpt5MXWCNBUDh9Nqy8pzh3X4Il
'' SIG '' Mj3pp7kbAlaGOJHnw75mPggUGzu/gM/U4pIPTL131pDq
'' SIG '' uY12VudKifP70Fh5adToDVzNIomLhR7s3Rl6w4JWkZuk
'' SIG '' lnYvJY+60DBjAf5VjZ+iDV2AIwq1K23Gy1dxMXGcghz5
'' SIG '' CAPoj8YfDefc7XIP54oDF9V8dPxTby4xO/nPll07AjAa
'' SIG '' 1OPjcCQEcEQeZlrZwLZ+EcAP8i0MwJ2YrswwFbcJeqMM
'' SIG '' mIitG3D6/2BIgUQ/OoJgRzz5XeOgjYhZtlFGGdMmOapS
'' SIG '' RG7drzJgimi9HAmYMvHavsaQvO8KrnTrl2yjvvYdDv8n
'' SIG '' YCmWNhkPkaMu6zMLbTEYn6qDkOcE4Fw4cMUP9qZNtBG2
'' SIG '' faHsjzyDghs7yb5AWfDnBqLEZg+i7bIa+CvLVGIknQP3
'' SIG '' S7ErCjv0WM7tm8opl2uy4zSSH2XcSLLav8ShghdAMIIX
'' SIG '' PAYKKwYBBAGCNwMDATGCFywwghcoBgkqhkiG9w0BBwKg
'' SIG '' ghcZMIIXFQIBAzEPMA0GCWCGSAFlAwQCAQUAMHgGCyqG
'' SIG '' SIb3DQEJEAEEoGkEZzBlAgEBBglghkgBhv1sBwEwMTAN
'' SIG '' BglghkgBZQMEAgEFAAQgrCYZTE9FfT2WgBqfIBZkWoYZ
'' SIG '' BwqBpFM+ukBrp/vlZjYCEQC3XHVIheF3Agk7TemBiOwz
'' SIG '' GA8yMDI0MDEyNjIzNTQ0MlqgghMJMIIGwjCCBKqgAwIB
'' SIG '' AgIQBUSv85SdCDmmv9s/X+VhFjANBgkqhkiG9w0BAQsF
'' SIG '' ADBjMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNl
'' SIG '' cnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0IFRydXN0
'' SIG '' ZWQgRzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1waW5n
'' SIG '' IENBMB4XDTIzMDcxNDAwMDAwMFoXDTM0MTAxMzIzNTk1
'' SIG '' OVowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lD
'' SIG '' ZXJ0LCBJbmMuMSAwHgYDVQQDExdEaWdpQ2VydCBUaW1l
'' SIG '' c3RhbXAgMjAyMzCCAiIwDQYJKoZIhvcNAQEBBQADggIP
'' SIG '' ADCCAgoCggIBAKNTRYcdg45brD5UsyPgz5/X5dLnXaEO
'' SIG '' CdwvSKOXejsqnGfcYhVYwamTEafNqrJq3RApih5iY2nT
'' SIG '' WJw1cb86l+uUUI8cIOrHmjsvlmbjaedp/lvD1isgHMGX
'' SIG '' lLSlUIHyz8sHpjBoyoNC2vx/CSSUpIIa2mq62DvKXd4Z
'' SIG '' GIX7ReoNYWyd/nFexAaaPPDFLnkPG2ZS48jWPl/aQ9OE
'' SIG '' 9dDH9kgtXkV1lnX+3RChG4PBuOZSlbVH13gpOWvgeFmX
'' SIG '' 40QrStWVzu8IF+qCZE3/I+PKhu60pCFkcOvV5aDaY7Mu
'' SIG '' 6QXuqvYk9R28mxyyt1/f8O52fTGZZUdVnUokL6wrl76f
'' SIG '' 5P17cz4y7lI0+9S769SgLDSb495uZBkHNwGRDxy1Uc2q
'' SIG '' TGaDiGhiu7xBG3gZbeTZD+BYQfvYsSzhUa+0rRUGFOpi
'' SIG '' CBPTaR58ZE2dD9/O0V6MqqtQFcmzyrzXxDtoRKOlO0L9
'' SIG '' c33u3Qr/eTQQfqZcClhMAD6FaXXHg2TWdc2PEnZWpST6
'' SIG '' 18RrIbroHzSYLzrqawGw9/sqhux7UjipmAmhcbJsca8+
'' SIG '' uG+W1eEQE/5hRwqM/vC2x9XH3mwk8L9CgsqgcT2ckpME
'' SIG '' tGlwJw1Pt7U20clfCKRwo+wK8REuZODLIivK8SgTIUlR
'' SIG '' fgZm0zu++uuRONhRB8qUt+JQofM604qDy0B7AgMBAAGj
'' SIG '' ggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/
'' SIG '' BAIwADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNV
'' SIG '' HSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYD
'' SIG '' VR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
'' SIG '' VR0OBBYEFKW27xPn783QZKHVVqllMaPe1eNJMFoGA1Ud
'' SIG '' HwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
'' SIG '' LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
'' SIG '' NTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEB
'' SIG '' BIGDMIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5k
'' SIG '' aWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
'' SIG '' YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0
'' SIG '' ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5j
'' SIG '' cnQwDQYJKoZIhvcNAQELBQADggIBAIEa1t6gqbWYF7xw
'' SIG '' jU+KPGic2CX/yyzkzepdIpLsjCICqbjPgKjZ5+PF7SaC
'' SIG '' inEvGN1Ott5s1+FgnCvt7T1IjrhrunxdvcJhN2hJd6Pr
'' SIG '' kKoS1yeF844ektrCQDifXcigLiV4JZ0qBXqEKZi2V3mP
'' SIG '' 2yZWK7Dzp703DNiYdk9WuVLCtp04qYHnbUFcjGnRuSvE
'' SIG '' xnvPnPp44pMadqJpddNQ5EQSviANnqlE0PjlSXcIWiHF
'' SIG '' tM+YlRpUurm8wWkZus8W8oM3NG6wQSbd3lqXTzON1I13
'' SIG '' fXVFoaVYJmoDRd7ZULVQjK9WvUzF4UbFKNOt50MAcN7M
'' SIG '' mJ4ZiQPq1JE3701S88lgIcRWR+3aEUuMMsOI5ljitts+
'' SIG '' +V+wQtaP4xeR0arAVeOGv6wnLEHQmjNKqDbUuXKWfpd5
'' SIG '' OEhfysLcPTLfddY2Z1qJ+Panx+VPNTwAvb6cKmx5Adza
'' SIG '' ROY63jg7B145WPR8czFVoIARyxQMfq68/qTreWWqaNYi
'' SIG '' yjvrmoI1VygWy2nyMpqy0tg6uLFGhmu6F/3Ed2wVbK6r
'' SIG '' r3M66ElGt9V/zLY4wNjsHPW2obhDLN9OTH0eaHDAdwrU
'' SIG '' AuBcYLso/zjlUlrWrBciI0707NMX+1Br/wd3H3GXREHJ
'' SIG '' uEbTbDJ8WC9nR2XlG3O2mflrLAZG70Ee8PBf4NvZrZCA
'' SIG '' RK+AEEGKMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0o
'' SIG '' ZipeWzANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJV
'' SIG '' UzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQL
'' SIG '' ExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdp
'' SIG '' Q2VydCBUcnVzdGVkIFJvb3QgRzQwHhcNMjIwMzIzMDAw
'' SIG '' MDAwWhcNMzcwMzIyMjM1OTU5WjBjMQswCQYDVQQGEwJV
'' SIG '' UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNV
'' SIG '' BAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBT
'' SIG '' SEEyNTYgVGltZVN0YW1waW5nIENBMIICIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFV
'' SIG '' xyUDxPKRN6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+k
'' SIG '' iPNo+n3znIkLf50fng8zH1ATCyZzlm34V6gCff1DtITa
'' SIG '' EfFzsbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW
'' SIG '' 1OcoLevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8
'' SIG '' ald68Dd5n12sy+iEZLRS8nZH92GDGd1ftFQLIWhuNyG7
'' SIG '' QKxfst5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRA
'' SIG '' p8ByxbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYn
'' SIG '' LvWHpo9OdhVVJnCYJn+gGkcgQ+NDY4B7dW4nJZCYOjgR
'' SIG '' s/b2nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU8lKV
'' SIG '' EStYdEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPV
'' SIG '' A+C/8KI8ykLcGEh/FDTP0kyr75s9/g64ZCr6dSgkQe1C
'' SIG '' vwWcZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwjjVj33GHe
'' SIG '' k/45wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtb
'' SIG '' iiKowSYI+RQQEgN9XyO7ZONj4KbhPvbCdLI/Hgl27Ktd
'' SIG '' RnXiYKNYCQEoAA6EVO7O6V3IXjASvUaetdN2udIOa5kM
'' SIG '' 0jO0zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYB
'' SIG '' Af8CAQAwHQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCP
'' SIG '' nshvMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/nupiu
'' SIG '' HA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBBBggr
'' SIG '' BgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYD
'' SIG '' VR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmww
'' SIG '' IAYDVR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcB
'' SIG '' MA0GCSqGSIb3DQEBCwUAA4ICAQB9WY7Ak7ZvmKlEIgF+
'' SIG '' ZtbYIULhsBguEE0TzzBTzr8Y+8dQXeJLKftwig2qKWn8
'' SIG '' acHPHQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExi
'' SIG '' HQwIgqgWvalWzxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6
'' SIG '' q4XNQ1/tYLaqT5Fmniye4Iqs5f2MvGQmh2ySvZ180HAK
'' SIG '' fO+ovHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAn
'' SIG '' gkSumScbqyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDn
'' SIG '' mPv7pp1yr8THwcFqcdnGE4AJxLafzYeHJLtPo0m5d2aR
'' SIG '' 8XKc6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un
'' SIG '' 8WbDQc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4
'' SIG '' c6umAU+9Pzt4rUyt+8SVe+0KXzM5h0F4ejjpnOHdI/0d
'' SIG '' KNPH+ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm
'' SIG '' 8heZWcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr
'' SIG '' 7ZVBtzrVFZgxtGIJDwq9gdkT/r+k0fNX2bwE+oLeMt8E
'' SIG '' ifAAzV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8apIUP
'' SIG '' /JiW9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv2
'' SIG '' 7dZ8/DCCBY0wggR1oAMCAQICEA6bGI750C3n79tQ4ghA
'' SIG '' GFowDQYJKoZIhvcNAQEMBQAwZTELMAkGA1UEBhMCVVMx
'' SIG '' FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
'' SIG '' d3d3LmRpZ2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNl
'' SIG '' cnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTIyMDgwMTAw
'' SIG '' MDAwMFoXDTMxMTEwOTIzNTk1OVowYjELMAkGA1UEBhMC
'' SIG '' VVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UE
'' SIG '' CxMQd3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGln
'' SIG '' aUNlcnQgVHJ1c3RlZCBSb290IEc0MIICIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAg8AMIICCgKCAgEAv+aQc2jeu+RdSjww
'' SIG '' IjBpM+zCpyUuySE98orYWcLhKac9WKt2ms2uexuEDcQw
'' SIG '' H/MbpDgW61bGl20dq7J58soR0uRf1gU8Ug9SH8aeFaV+
'' SIG '' vp+pVxZZVXKvaJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0
'' SIG '' O21x4i0MG+4g1ckgHWMpLc7sXk7Ik/ghYZs06wXGXuxb
'' SIG '' Grzryc/NrDRAX7F6Zu53yEioZldXn1RYjgwrt0+nMNlW
'' SIG '' 7sp7XeOtyU9e5TXnMcvak17cjo+A2raRmECQecN4x7ax
'' SIG '' xLVqGDgDEI3Y1DekLgV9iPWCPhCRcKtVgkEy19sEcypu
'' SIG '' kQF8IUzUvK4bA3VdeGbZOjFEmjNAvwjXWkmkwuapoGfd
'' SIG '' pCe8oU85tRFYF/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6
'' SIG '' SPDgohIbZpp0yt5LHucOY67m1O+SkjqePdwA5EUlibaa
'' SIG '' RBkrfsCUtNJhbesz2cXfSwQAzH0clcOP9yGyshG3u3/y
'' SIG '' 1YxwLEFgqrFjGESVGnZifvaAsPvoZKYz0YkH4b235kOk
'' SIG '' GLimdwHhD5QMIR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxf
'' SIG '' jT/JvNNBERJb5RBQ6zHFynIWIgnffEx1P2PsIV/EIFFr
'' SIG '' b7GrhotPwtZFX50g/KEexcCPorF+CiaZ9eRpL5gdLfXZ
'' SIG '' qbId5RsCAwEAAaOCATowggE2MA8GA1UdEwEB/wQFMAMB
'' SIG '' Af8wHQYDVR0OBBYEFOzX44LScV1kTN8uZz/nupiuHA9P
'' SIG '' MB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgP
'' SIG '' MA4GA1UdDwEB/wQEAwIBhjB5BggrBgEFBQcBAQRtMGsw
'' SIG '' JAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
'' SIG '' LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMu
'' SIG '' ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
'' SIG '' dENBLmNydDBFBgNVHR8EPjA8MDqgOKA2hjRodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVk
'' SIG '' SURSb290Q0EuY3JsMBEGA1UdIAQKMAgwBgYEVR0gADAN
'' SIG '' BgkqhkiG9w0BAQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22
'' SIG '' Ftf3v1cHvZqsoYcs7IVeqRq7IviHGmlUIu2kiHdtvRoU
'' SIG '' 9BNKei8ttzjv9P+Aufih9/Jy3iS8UgPITtAq3votVs/5
'' SIG '' 9PesMHqai7Je1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cn
'' SIG '' RNTnf+hZqPC/Lwum6fI0POz3A8eHqNJMQBk1RmppVLC4
'' SIG '' oVaO7KTVPeix3P0c2PR3WlxUjG/voVA9/HYJaISfb8rb
'' SIG '' II01YBwCA8sgsKxYoA5AY8WYIsGyWfVVa88nq2x2zm8j
'' SIG '' LfR+cWojayL/ErhULSd+2DrZ8LaHlv1b0VysGMNNn3O3
'' SIG '' AamfV6peKOK5lDGCA3YwggNyAgEBMHcwYzELMAkGA1UE
'' SIG '' BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTsw
'' SIG '' OQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
'' SIG '' OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQBUSv85Sd
'' SIG '' CDmmv9s/X+VhFjANBglghkgBZQMEAgEFAKCB0TAaBgkq
'' SIG '' hkiG9w0BCQMxDQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcN
'' SIG '' AQkFMQ8XDTI0MDEyNjIzNTQ0MlowKwYLKoZIhvcNAQkQ
'' SIG '' AgwxHDAaMBgwFgQUZvArMsLCyQ+CXc6qisnGTxmcz0Aw
'' SIG '' LwYJKoZIhvcNAQkEMSIEIMLKccDUu8DxE0MZ+2FbS22W
'' SIG '' oeSO/qJtHW8RLiWF3niUMDcGCyqGSIb3DQEJEAIvMSgw
'' SIG '' JjAkMCIEINL25G3tdCLM0dRAV2hBNm+CitpVmq4zFq9N
'' SIG '' GprUDHgoMA0GCSqGSIb3DQEBAQUABIICAG5MtNPrlmq1
'' SIG '' GLaBGQSXTlWVswYScoE9xrfM3vDimm08Lu2xp1QKcLj8
'' SIG '' m77Tsz8iZ+2HORKFh4rEx6oZqnElzmR5iVM3O6Dwcta3
'' SIG '' pvEBWsMNNL1WtvLHumEHRfm+f78KMDLAW4DJTuNAL79j
'' SIG '' g3Ziwc5QtYqjN6ifxnb2h+K79gMMMaDI4sz5QgTtV2xA
'' SIG '' iEkF/5qsMSe1ypiNv2TMQ30AmKF8iyTdT8GWIpBF+fNy
'' SIG '' cHdUYyVNxIw3fqJaWYMwhXTGXM1YoxzO952xcsNpxxL7
'' SIG '' fLIIovvHXxTNxlGRMvf2Gj8/yah/DeSHGJWgf7ls5x9s
'' SIG '' Os7G2s7b5z9TdCGsKt2ATmifomL2A4mM6R2n7+xVkF0u
'' SIG '' DK6joenHKpzoBLYxWZaK3Ln0jiJXMM3JJHtHOAyZEaKe
'' SIG '' 6JdLKKFUyuNLFsblOI+qqDoLGF6JMI0S7vzNYbO8yQzP
'' SIG '' zV2CPBIdPKhaNOS2c0+1vi7esKM8Q7fs0YPnPtPC3fMl
'' SIG '' BykAL+edQej9F288QLA3HCFiaChQUgh2uDe0sXGdVxLu
'' SIG '' YY/RFW8oz/IPOzgv/+sREyPqFKI4YGgWRF8elPYNJOFp
'' SIG '' rafufts6Ggt/7Tga4iMIZUYkKaLfNvCKy0z+2pkNsnli
'' SIG '' kUFCZHdLFupM+Wd1Kwt9yzQjcpCbeUaEd2R7G0IlGzmU
'' SIG '' 0P2XPJ5wTfE4
'' SIG '' End signature block
